<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Eel\Helper;

use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Newland\Contracts\Neos\Search\SearchBackend;
use Newland\Contracts\Neos\Search\SearchRequest;
use Newland\Contracts\Neos\Search\SearchResultCollection;
use Newland\Toubiz\Search\Neos\Backend\SearchBackendFactory;

/**
 * Eel Helper to process the ElasticSearch Query Result
 */
class SearchResultHelper implements ProtectedContextAwareInterface
{
    /**
     * @var array
     * @Flow\InjectConfiguration(path="availableTypes")
     */
    protected $availableTypes;

    /** @var SearchBackend */
    protected $searchBackend;
    public function injectSearchBackend(SearchBackendFactory $factory): void
    {
        $this->searchBackend = $factory->getSearchBackendFromConfiguration();
    }

    /**
     * Run search query using ElasticSearchConnector.
     *
     * Returns hits object of Elastic Search API Response Content.
     */
    public function query(
        string $searchTerm,
        int $itemsPerPage,
        int $currentPage,
        string $language,
        string $scope,
        array $userEnabledTypes
    ): SearchResultCollection {
        return $this->searchBackend->search(
            new SearchRequest(
                $searchTerm,
                $language,
                [ $scope ],
                $userEnabledTypes ?: $this->typesFromConfiguration(),
                $itemsPerPage,
                $currentPage
            )
        );
    }

    private function typesFromConfiguration(): array
    {
        return array_keys(array_filter($this->availableTypes ?: []));
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return true;
    }
}
