<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\ViewHelpers;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Service\PageFrameLinkingService;

/**
 * Search action URI view helper.
 *
 * Returns the correct action URI for the search page.
 *
 * @Flow\Scope("singleton")
 */
class SearchActionUriViewHelper extends AbstractViewHelper
{
    /**
     * @var PageFrameLinkingService
     * @Flow\Inject()
     */
    protected $pageFrameLinkingService;

    public function initializeArguments(): void
    {
        $this->registerArgument(
            'referenceNode',
            NodeInterface::class,
            'The node used as a reference',
            true
        );
    }

    public function render(): string
    {
        return $this->pageFrameLinkingService->build(
            $this->controllerContext->getUriBuilder(),
            'newland.toubiz.search.neos',
            'searches',
            'result',
            'search',
            [],
            PageFrameLinkingService::DEFAULT_ARGUMENT_NAMESPACE,
            $this->arguments['referenceNode']
        );
    }
}
