<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\ViewHelpers;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchResult;

/**
 * Partial path view helper.
 *
 * Resolves the configured partial path for rendering a search result.
 *
 * @Flow\Scope("singleton")
 */
class PartialPathViewHelper extends AbstractViewHelper
{
    /**
     * @Flow\InjectConfiguration(path="indexers")
     * @var array
     */
    protected $configuration;

    public function initializeArguments(): void
    {
        $this->registerArgument('searchResult', SearchResult::class, null, false, null);
    }

    public function render(): ?string
    {
        /** @var SearchResult|null $searchResult */
        $searchResult = $this->arguments['searchResult'];
        if (!$searchResult) {
            return null;
        }

        $indexerName = $searchResult->getSearchIndex()->getSource();
        $indexerConfiguration = $this->configuration[$indexerName]['configuration'];
        return $indexerConfiguration['searchResultTemplate'];
    }
}
