<?php

namespace Newland\Toubiz\Search\Neos\PageFrame;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Newland\PageFrameProvider\Routing\UriResolver;
use Newland\PageFrameProvider\Service\PageFrameContextService;

/**
 * @Flow\Scope("singleton")
 */
class SearchUriResolver implements UriResolver
{
    const FALLBACK_LANGUAGE = 'en';
    const FALLBACK_URI_SEGMENT = 'search';

    /**
     * @var PageFrameContextService
     * @Flow\Inject()
     */
    protected $pageFrameContext;

    /**
     * @Flow\InjectConfiguration(path="uriPathSegments")
     * @var array
     */
    protected $uriPathSegments;

    public function getMatchingDomainSpecificPath(string $requestPath): ?string
    {
        foreach ($this->uriPathSegments as $segment) {
            if (strpos($requestPath, $segment) === 0) {
                return $segment;
            }
        }
        return null;
    }

    public function resolveDomainSpecificPath(array &$routeValues, NodeInterface $node): ?string
    {
        $dimensions = $this->pageFrameContext->getDimensions();
        $language = $dimensions['language'][0] ?? static::FALLBACK_LANGUAGE;
        return $this->uriPathSegments[$language] ?? static::FALLBACK_URI_SEGMENT;
    }
}
