<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Contracts\Neos\Search\ObjectFinderInterface;

/**
 * Generic finder for database records based on a configured repository.
 *
 * @Flow\Scope("singleton")
 */
class RecordObjectFinder extends AbstractObjectFinder implements ObjectFinderInterface
{
    /**
     * Finds the corresponding node object.
     *
     * @return mixed
     */
    public function find()
    {
        // At this point we have no idea what `$repository` is and what `find` means.
        // TODO Refactor to be more type safe.
        $repository = new $this->configuration['repository'];
        return $repository->find($this->searchIndex->getIdentifier());
    }
}
