<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Contracts\Neos\Search\ObjectFinderInterface;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchIndex;

/**
 * @Flow\Scope("singleton")
 */
abstract class AbstractObjectFinder implements ObjectFinderInterface
{
    /**
     * @var SearchIndex
     */
    protected $searchIndex;

    /**
     * @var array
     */
    protected $configuration = [];

    public function setSearchIndex(SearchIndex $searchIndex): void
    {
        $this->searchIndex = $searchIndex;
    }

    public function getSearchIndex(): SearchIndex
    {
        return $this->searchIndex;
    }

    public function setConfiguration(array $configuration = []): void
    {
        $this->configuration = $configuration;
    }
}
