<?php

declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Eel\Helper;

use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Annotations as Flow;

class PaginationHelper implements ProtectedContextAwareInterface
{
    /**
     * Generate properties for rendering search pagination.
     *
     * @param float $currentPage
     * @param float $totalPageCount
     * @return object
     */
    public function generate(float $currentPage, float $totalPageCount)
    {
        $showStartItems = $totalPageCount > 2 && ($totalPageCount <= 7 || ($currentPage <= 4 && $totalPageCount > 7));
        $startItemCount = $totalPageCount <= 7 ? $totalPageCount - 2 : 4;
        $showMidItems = $currentPage > 4 && $totalPageCount - $currentPage > 3;
        $midItemIndex = (int) ($currentPage - 1);
        $showEndItems = $totalPageCount > 7 && $totalPageCount - $currentPage <= 3;
        $endItemIndex = (int) ($currentPage - 1);
        $current = (int) $currentPage;
        $total = (int) $totalPageCount;

        $startItems = [];
        for ($i = 1; $i <= $startItemCount; $i++) {
            $startItems[] = $i + 1;
        }

        $midItems = [];
        for ($i = 0; $i < 3; $i++) {
            $midItems[] = $i + $midItemIndex;
        }

        $endItems = [];
        for ($i = 4; $i > 0; $i--) {
            $endItems[] = $total - $i;
        }

        return [
            'showStartItems' => $showStartItems,
            'showMidItems' => $showMidItems,
            'showEndItems' => $showEndItems,
            'startItems' => $startItems,
            'midItems' => $midItems,
            'endItems' => $endItems,
            'current' => $current,
            'total' => $total,
            'prevPage' => $current + -1,
            'nextPage' => $current + 1,
        ];
    }

    /**
     * @param string $methodName
     * @return boolean
     */
    public function allowsCallOfMethod($methodName)
    {
        return true;
    }
}
