<?php

namespace Newland\Toubiz\Search\Neos\DataSource;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Neos\Service\DataSource\AbstractDataSource;

/**
 * Categories data source service.
 *
 * @Flow\Scope("singleton")
 */
class AvailableScopesDataSource extends AbstractDataSource
{
    /**
     * Data source identifier.
     *
     * @var string
     */
    protected static $identifier = 'newland-toubiz-search-neos-scopes';

    /**
     * @var ConfigurationManager
     * @Flow\Inject()
     */
    protected $configurationManager;

    /**
     * @var Translator
     * @Flow\Inject()
     */
    protected $translator;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     * @throws \Neos\ContentRepository\Exception\NodeException
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $availableScopes = $this->configurationManager->getConfiguration(
            ConfigurationManager::CONFIGURATION_TYPE_SETTINGS,
            'Newland.Toubiz.Search.Neos.availableScopes'
        );

        $data = [];
        foreach ($availableScopes as $scope => $isEnabled) {
            if ($isEnabled) {
                $data[] = [
                    'value' => $scope,
                    'label' => $this->translate('properties.preselectedScopes.selectBoxEditor.values.' . $scope),
                ];
            }
        }

        return $data;
    }

    /**
     * @param string $id
     * @return string|null
     */
    private function translate(string $id): ?string
    {
        return $this->translator->translateById(
            $id,
            [],
            null,
            null,
            'NodeTypes/Search',
            'Newland.Toubiz.Search.Neos'
        );
    }
}
