<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Backend;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;

use Flowpack\ElasticSearch\Domain\Model\Document as ElasticSearchDocument;
use Flowpack\ElasticSearch\Domain\Factory\ClientFactory;

use Neos\Utility\Arrays;

use function Safe\preg_replace;

class ElasticSearchConnector
{
    /**
     * @Flow\InjectConfiguration(package="Flowpack.ElasticSearch", path="indexName")
     * @var string
     */
    protected $indexName;

    /**
     * @Flow\Inject
     * @var ClientFactory
     */
    protected $clientFactory;

    /** @var object */
    protected $type;

    protected function initializeObject()
    {
        $client = $this->clientFactory->create();
        $searchIndex = $this->indexName;
        if(isset($searchIndex)) {
            $index = $client->findIndex($searchIndex);
            $this->type = new ElasticSearchObjectType($index);
        }
    }

    /**
     * Use type reference to perform search request.
     *
     * @param array $arguments
     **/
    public function search(array $arguments)
    {
        return $this->type->search($arguments);
    }

    /**
     * Use type reference to create/update index object.
     *
     * @param array $indexContent
     * @param string $identifier
     **/
    public function addOrUpdateObject(array $indexContent, string $identifier): void
    {
        $document = new ElasticSearchDocument($this->type, $indexContent, $identifier);
        $document->store();
    }

    /**
     * Use type reference to delete index object.
     *
     * @param string $identifier
     **/
    public function removeObject(string $identifier)
    {
        $this->type->deleteDocumentById($identifier);
    }
}
