<?php
namespace Newland\Toubiz\Search\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Search\Neos\Domain\Repository\SearchSuggestionRepository;

/**
 * The widget controller for the search suggestions widget.
 */
class SearchSuggestionsController extends AbstractWidgetController
{
    /**
     * @Flow\Inject
     * @var SearchSuggestionRepository
     */
    protected $searchSuggestionRepository;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction()
    {
        $this->view->assign(
            'suggestions',
            $this->searchSuggestionRepository->findAll()
        );
    }
}
