<?php
namespace Newland\Toubiz\Search\Neos\Domain\Repository\History;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\Doctrine\Repository;

/**
 * History search query repository.
 *
 * @Flow\Scope("singleton")
 */
class SearchQueryRepository extends Repository
{
    /**
     * Returns a list of popular queries.
     *
     * @return array
     */
    public function getPopularQueryStrings()
    {
        $query = $this->createQueryBuilder('s');
        $query->select('
            s.queryString, s.scope, s.language,
            COUNT(s.queryString) as query_count
        ');
        $query->where('s.scope != :empty AND s.language != :empty')
              ->setParameter('empty', '')
              ->orderBy('query_count', 'DESC')
              ->groupBy('s.queryString, s.scope, s.language')
              ->having('query_count > 1')
              ->setMaxResults(10);

        return $query->getQuery()->getScalarResult();
    }
}
