<?php
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * Search suggestion model.
 *
 * Represents a search suggestion that is either being
 * generated through a script based on historical queries,
 * or may be manually added.
 *
 * @Flow\Entity
 */
class SearchSuggestion
{
    /**
     * The suggestion.
     *
     * @var string
     */
    protected $name;

    /**
     * The scope for this suggestion.
     *
     * @var string
     * @ORM\Column(nullable=TRUE)
     */
    protected $scope;

    /**
     * The language for this suggestion.
     *
     * @var string
     * @ORM\Column(nullable=TRUE)
     */
    protected $language;

    /**
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $scope
     * @return void
     */
    public function setScope($scope)
    {
        $this->scope = $scope;
    }

    /**
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * @param string $language
     * @return void
     */
    public function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
}
