<?php
namespace Newland\Toubiz\Search\Neos\Domain\Model\History;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * History search query model.
 *
 * Represents what a visitor has been queried through the search.
 *
 * @Flow\Entity
 */
class SearchQuery extends \Newland\Toubiz\Search\Neos\Domain\Model\SearchQuery
{
    /**
     * The query string.
     *
     * @var string
     */
    protected $queryString;

    /**
     * Date and time the query has been submitted.
     *
     * @var \DateTime
     */
    protected $createdAt;

    /**
     * Object initializer.
     *
     * @return void
     */
    public function initializeObject()
    {
        $this->createdAt = new \DateTime;
    }
}
