<?php
namespace Newland\Toubiz\Search\Neos\Command;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cli\CommandController;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchSuggestion;
use Newland\Toubiz\Search\Neos\Domain\Repository\SearchSuggestionRepository;
use Newland\Toubiz\Search\Neos\Domain\Repository\History\SearchQueryRepository as HistorySearchQueryRepository;

/**
 * Search data command controller.
 *
 * @Flow\Scope("singleton")
 */
class SearchDataCommandController extends CommandController
{
    /**
     * @var HistorySearchQueryRepository
     * @Flow\Inject
     */
    protected $historySearchQueryRepository;

    /**
     * @var SearchSuggestionRepository
     * @Flow\Inject
     */
    protected $searchSuggestionRepository;

    /**
     * Process command.
     *
     * Processes internal stored data.
     *
     * @return void
     */
    public function processCommand()
    {
        $this->generateSearchSuggestions();
    }

    /**
     * Updates the search suggestions table by processing
     * historical queries.
     *
     * @return void
     */
    protected function generateSearchSuggestions()
    {
        $popularSearches = $this->historySearchQueryRepository->getPopularQueryStrings();
        if (empty($popularSearches)) {
            return;
        }

        $this->searchSuggestionRepository->deleteAll();

        foreach ($popularSearches as $popular) {
            $suggestion = new SearchSuggestion;
            $suggestion->setName($popular['queryString']);
            $suggestion->setScope($popular['scope']);
            $suggestion->setLanguage($popular['language']);
            $this->searchSuggestionRepository->add($suggestion);
        }
    }
}
