<?php
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchIndex;

/**
 * Abstract object finder.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractObjectFinder
{
    /**
     * @var SearchIndex
     */
    protected $searchIndex;

    /**
     * @var array
     */
    protected $configuration = [];

    /**
     * @param SearchIndex $searchIndex
     * @return void
     */
    public function setSearchIndex(SearchIndex $searchIndex)
    {
        $this->searchIndex = $searchIndex;
    }

    /**
     * @return SearchIndex
     */
    public function getSearchIndex()
    {
        return $this->searchIndex;
    }

    /**
     * Sets configurations for the object finder.
     *
     * @var array $configuration
     * @return void
     */
    public function setConfiguration(array $configuration = [])
    {
        $this->configuration = $configuration;
    }
}
