<?php
namespace Newland\Toubiz\Search\Neos\Domain\Search;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\QueryBuilder;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\Doctrine\Repository;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchQuery;

/**
 * Search classes interface.
 */
interface SearchInterface
{
    /**
     * Get query.
     *
     * Builds a query with the given search query data,
     * based on the given repository.
     *
     * @param SearchQuery $search
     * @param Repository $repository
     * @return QueryBuilder
     */
    public function getQuery(SearchQuery $search, $repository);
}
