<?php
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * Search result model.
 *
 * Represents the search index entry together with the original object.
 *
 * @Flow\Scope("singleton")
 */
class SearchResult
{
    /**
     * @var SearchIndex
     */
    protected $searchIndex;

    /**
     * @var mixed
     */
    protected $originalObject;

    /**
     * @param SearchIndex $searchIndex
     * @return void
     */
    public function setSearchIndex(SearchIndex $searchIndex)
    {
        $this->searchIndex = $searchIndex;
    }

    /**
     * @return SearchIndex
     */
    public function getSearchIndex()
    {
        return $this->searchIndex;
    }

    /**
     * @var mixed $originalObject
     * @return void
     */
    public function setOriginalObject($originalObject)
    {
        $this->originalObject = $originalObject;
    }

    /**
     * @return mixed
     */
    public function getOriginalObject()
    {
        return $this->originalObject;
    }
}
