<?php
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * Search index model.
 *
 * Represents a single entry in the whole index.
 *
 * @Flow\Entity
 * @ORM\Table(indexes={
 *   @ORM\Index(name="identifier", columns={"identifier"}),
 *   @ORM\index(name="scope", columns={"scope"}),
 *   @ORM\Index(name="fulltext_content", columns={"content"}, flags={"fulltext"})
 * })
 */
class SearchIndex
{
    /**
     * @var string Document node identifier.
     * @ORM\Column(nullable=TRUE)
     */
    protected $identifier;

    /**
     * @var string Indexer source for this entry.
     */
    protected $source;

    /**
     * @var string The indexed content.
     * @ORM\Column(type="text")
     */
    protected $content;

    /**
     * @var string Search result title.
     * @ORM\Column(nullable=TRUE)
     */
    protected $title;

    /**
     * @var string Search result abstract.
     * @ORM\Column(type="text", nullable=TRUE)
     */
    protected $description;

    /**
     * @var string
     * @ORM\Column(nullable=TRUE)
     */
    protected $scope;

    /**
     * @var string
     * @ORM\Column(nullable=TRUE)
     */
    protected $language;

    /**
     * @param string $identifier
     * @return void
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @var string $source
     */
    public function setSource($source)
    {
        $this->source = $source;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * @param string $content
     * @return void
     */
    public function setContent($content)
    {
        $this->content = $content;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $description
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $scope
     * @return void
     */
    public function setScope($scope)
    {
        $this->scope = $scope;
    }

    /**
     * @var string $language
     * @return void
     */
    public function setLanguage($language)
    {
        $this->language = $language;
    }
}
