<?php
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Service\ContextFactoryInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;

/**
 * Document node object finder.
 *
 * @Flow\Scope("singleton")
 */
class DocumentNodeObjectFinder extends AbstractObjectFinder implements ObjectFinderInterface
{
    /**
     * @var ContextFactoryInterface
     * @Flow\Inject
     */
    protected $contextFactory;

    /**
     * Finds the corresponding node object.
     *
     * @return Node
     */
    public function find()
    {
        $options = [];
        if ($this->getSearchIndex()->getLanguage()) {
            $options['dimensions'] = [
                'language' => [$this->getSearchIndex()->getLanguage()]
            ];
        }
        $query =  new FlowQuery([$this->getContext($options)->getCurrentSiteNode()]);
        return $query->find('#' . $this->getSearchIndex()->getIdentifier())->get(0);
    }

    /**
     * Builds a context for querying with flow query.
     *
     * @param array $options
     * @return \Neos\ContentRepository\Domain\Service\Context
     */
    protected function getContext(array $options = [])
    {
        return $this->contextFactory->create(
            array_merge(
                [
                    'workspaceName' => 'live',
                    'currentDateTime' => new \Neos\Flow\Utility\Now(),
                    'dimensions' => [],
                    'invisibleContentShown' => false,
                    'removedContentShown' => false,
                    'inaccessibleContentShown' => false
                ],
                $options
            )
        );
    }
}
