<?php
namespace Newland\Toubiz\Search\Neos\Extractor;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use LukeMadhanga\DocumentParser;

/**
 * Word extractor.
 *
 * @Flow\Scope("singleton")
 */
class WordExtractor extends AbstractExtractor implements ExtractorInterface
{
    /**
     * Extracts text from given resource.
     *
     * @return string|null
     */
    public function extract()
    {
        try {
            $path = $this->resource->createTemporaryLocalCopy();
            return DocumentParser::parseFromFile($path);
            unlink($path);
        } catch (\Exception $e) {
            // Skip asset due to it being not available.
        }
    }
}
