<?php
namespace Newland\Toubiz\Search\Neos\Extractor;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * Extractor factory.
 *
 * @Flow\Scope("singleton")
 */
class ExtractorFactory
{
    /**
     * Get factory for given mime type.
     *
     * @param string $mimeType
     * @return FactoryInterface
     */
    public static function getByMimeType($mimeType)
    {
        switch ($mimeType) {
            case 'application/pdf':
                return new PdfExtractor;

            case 'application/msword':
            case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
                return new WordExtractor;
        }
    }
}
