<?php
namespace Newland\Toubiz\Search\Neos\Extractor;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\ResourceManagement\PersistentResource;

/**
 * Abstract extractor class.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractExtractor
{
    /**
     * @var PersistentResource
     */
    protected $resource;

    /**
     * @param PersistentResource $resource
     * @return void
     */
    public function setResource(PersistentResource $resource)
    {
        $this->resource = $resource;
    }
}
