<?php
namespace Newland\Toubiz\Search\Neos\Command;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cli\CommandController;

/**
 * Indexer command controller.
 *
 * @Flow\Scope("singleton")
 */
class IndexerCommandController extends CommandController
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Run command.
     *
     * Updates the index based on registered indexers.
     *
     * @return void
     */
    public function runCommand()
    {
        foreach ($this->configuration['indexers'] as $className => $configuration) {
            if (array_key_exists('enable', $configuration) && !$configuration['enable']) {
                continue;
            }

            $indexer = new $className;
            if (array_key_exists('configuration', $configuration)) {
                $indexer->setConfiguration($configuration['configuration']);
            }
            $indexer->index();
            $indexer->postIndex();
        }
    }
}
