<?php
namespace Newland\Toubiz\Search\Neos\ViewHelpers;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchResult;

/**
 * Search action URI view helper.
 *
 * Returns the correct action URI for the search page.
 *
 * @Flow\Scope("singleton")
 */
class SearchActionUriViewHelper extends AbstractViewHelper
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration(path="uriPathSegments")
     * @var array
     */
    protected $uriPathSegments;

    /**
     * @var \Neos\ContentRepository\Domain\Repository\NodeDataRepository
     * @Flow\Inject
     */
    protected $nodeDataRepository;

    /**
     * @return string
     */
    public function render()
    {
        $language = $this->getLanguageDimension();
        if ($language) {
            $pathSegments = [
                $language,
                $this->uriPathSegments[$language]
            ];
        } else {
            $pathSegments = ['search'];
        }

        return '/' . implode('/', $pathSegments);
    }

    /**
     * Gets the current language dimension string.
     *
     * If no internal `node` argument is given (which is a Node object),
     * the internal node request argument (which is a context path string) is
     * used and the language is fetched from it directly.
     *
     * @return string
     */
    protected function getLanguageDimension()
    {
        $node = $this->controllerContext->getRequest()->getInternalArgument('__node');
        if ($node) {
            $dimensions = $node->getDimensions();
            if (array_key_exists('language', $dimensions)) {
                return $dimensions['language'][0];
            }
        }

        $nodePath = $this->controllerContext->getRequest()->getArgument('node');
        preg_match('/language=(.+)/', $nodePath, $matches);
        return $matches[1];
    }
}
