<?php
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Service\ContextFactoryInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;

/**
 * Record object finder.
 *
 * Generic finder for database records based on a configured repository.
 *
 * @Flow\Scope("singleton")
 */
class RecordObjectFinder extends AbstractObjectFinder implements ObjectFinderInterface
{
    /**
     * Finds the corresponding node object.
     *
     * @return mixed
     */
    public function find()
    {
        $repository = new $this->configuration['repository'];
        return $repository->find($this->searchIndex->getIdentifier());
    }
}
