<?php
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * Search query model.
 *
 * Represents a search query.
 *
 * @Flow\Scope("singleton")
 */
class SearchQuery
{
    /**
     * The query string.
     *
     * @var string
     */
    protected $queryString;

    /**
     * The scope to be searched.
     *
     * @var string
     * @ORM\Column(nullable=TRUE)
     */
    protected $scope;

    /**
     * The language to be searched.
     *
     * @var string
     * @ORM\Column(nullable=TRUE)
     */
    protected $language;

    /**
     * @param string $queryString
     * @return void
     */
    public function setQueryString($queryString)
    {
        $this->queryString = $queryString;
    }

    /**
     * @return string
     */
    public function getQueryString()
    {
        return $this->queryString;
    }

    /**
     * @return array
     */
    public function getSearchWords()
    {
        return explode(' ', $this->queryString);
    }

    /**
     * Checks if the given query string is considered empty.
     *
     * @return bool
     */
    public function isEmpty()
    {
        return preg_match('/\w+/', $this->queryString) == false;
    }

    /**
     * @param string $scope
     * @return void
     */
    public function setScope($scope)
    {
        $this->scope = $scope;
    }

    /**
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * @param string $language
     * @return void
     */
    public function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @return bool
     */
    public function hasLanguage()
    {
        return (!empty($this->language));
    }
}
