<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\Routing;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Routing\AbstractRoutePart;
use Neos\Flow\Mvc\Routing\Dto\MatchResult;
use Neos\Flow\Mvc\Routing\Dto\ResolveResult;
use Neos\Flow\Mvc\Routing\DynamicRoutePartInterface;
use Newland\PageFrameProvider\Service\PageFrameContextService;

/**
 * Search Route part handler.
 *
 * @Flow\Scope("prototype")
 */
class SearchRoutePart extends AbstractRoutePart implements DynamicRoutePartInterface
{
    private const FALLBACK_LANGUAGE = 'en';
    private const FALLBACK_URI_SEGMENT = 'search';

    /**
     * @var PageFrameContextService
     * @Flow\Inject
     */
    protected $pageFrameContext;

    /**
     * @Flow\InjectConfiguration(path="uriPathSegments")
     * @var array
     */
    protected $uriPathSegments;

    /**
     * Checks whether this Route Part corresponds to the given $routePath.
     *
     * @param string $routePath The request path to be matched - without query parameters, host and fragment.
     * @return bool|MatchResult true or an instance of MatchResult if Route Part matched $routePath, otherwise false.
     */
    public function match(&$routePath)
    {
        if (\in_array($routePath, $this->uriPathSegments)) {
            $routePath = str_replace($this->uriPathSegments, '', $routePath);
            return true;
        }
        return false;
    }

    /**
     * Checks whether this Route Part corresponds to the given $routeValues.
     * This method does not only check if the Route Part matches. It also
     * removes resolved elements from $routeValues-Array.
     * This is why $routeValues has to be passed by reference.
     *
     * @param array $routeValues An array with key/value pairs to be resolved by Dynamic Route Parts.
     * @return bool|ResolveResult true or an instance of ResolveResult if Route Part can resolve one or more
     *     $routeValues elements, otherwise false.
     */
    public function resolve(array &$routeValues)
    {
        $dimensions = $this->pageFrameContext->getDimensions();
        $language = $dimensions['language'][0] ?? static::FALLBACK_LANGUAGE;
        $segmentName = $this->uriPathSegments[$language] ?? static::FALLBACK_URI_SEGMENT;

        return new ResolveResult($segmentName);
    }

    public function setSplitString($splitString)
    {
        // Does nothing.
    }
}
