<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * Search query model.
 *
 * Represents a search query.
 *
 * @Flow\Scope("singleton")
 */
class SearchQuery
{
    /**
     * The query string.
     *
     * @var string
     */
    protected $queryString = '';

    /**
     * The scope to be searched.
     *
     * @var string|null
     * @ORM\Column(nullable=TRUE)
     */
    protected $scope;

    /**
     * The language to be searched.
     *
     * @var string|null
     * @ORM\Column(nullable=TRUE)
     */
    protected $language;

    /**
     * Sets given arguments.
     *
     * @param array $arguments
     * @return void
     */
    public function setArguments(array $arguments): void
    {
        foreach ($arguments as $name => $value) {
            $this->$name = $value;
        }
    }

    public function setQueryString(string $queryString): void
    {
        $this->queryString = $queryString;
    }

    public function getQueryString(): string
    {
        return $this->queryString;
    }

    public function getSearchWords(): array
    {
        return explode(' ', $this->queryString);
    }

    public function isEmpty(): bool
    {
        return preg_match('/\w+/', $this->queryString) === false;
    }

    public function setScope(?string $scope): void
    {
        $this->scope = $scope;
    }

    public function getScope(): ?string
    {
        return $this->scope;
    }

    public function setLanguage(?string $language): void
    {
        $this->language = $language;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function hasLanguage(): bool
    {
        return !empty($this->language);
    }
}
