<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\ViewHelpers;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class StringContainsViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('contains', 'string', 'String to contain', true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $context
    ): bool {
        return strpos($renderChildrenClosure(), $arguments['contains']) !== false;
    }
}
