<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Eel\Helper;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Mvc\Controller\ControllerContext;
use Neos\Neos\Service\LinkingService;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\Service\ControllerContextFactory;

class DocumentHelper implements ProtectedContextAwareInterface
{

    /**
     * @var LinkingService
     * @Flow\Inject()
     */
    protected $linkingService;

    /**
     * @var ControllerContextFactory
     * @Flow\Inject()
     */
    protected $controllerContextFactory;

    public function url(NodeInterface $node): string
    {
        return $this->linkingService->createNodeUri(
            $this->controllerContextFactory->initializeFakeControllerContext($node),
            $node
        );
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return $methodName === 'url';
    }
}
