<?php declare(strict_types=1);

/*
 * Copyright (c) 2023, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Newland\Toubiz\Search\Neos\Controller;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\JsonView;
use Newland\Contracts\Neos\Search\SearchBackend;
use Newland\Contracts\Neos\Search\SuggestRequest;
use Newland\Toubiz\Search\Neos\Backend\SearchBackendFactory;

class SearchController extends ActionController
{
    /** @var SearchBackend */
    protected $searchBackend;

    /**
     * @var array
     * @Flow\InjectConfiguration()
     */
    protected $configuration;

    public function injectSearchBackend(SearchBackendFactory $factory): void
    {
        $this->searchBackend = $factory->getSearchBackendFromConfiguration();
    }

    public function suggestAction(): string
    {
        $arguments = $this->request->getArguments();
        $searchTerm = $arguments['searchTerm'];
        $language = $arguments['language'];

        $suggestions = $this->searchBackend->suggest(
            new SuggestRequest(
                $searchTerm,
                'title_suggest',
                $language,
                $this->configuration['suggestions']['limit'] ?? 10,
            )
        );

        $view = new JsonView();
        $view->setControllerContext($this->controllerContext);
        $view->assign('value', $suggestions);
        return $view->render();
    }
}
