<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Tests\Mock;

use Newland\Contracts\Neos\Search\IndexRecordModification;
use Newland\Contracts\Neos\Search\SearchBackend;
use Newland\Contracts\Neos\Search\SearchRequest;
use Newland\Contracts\Neos\Search\SearchResultCollection;
use Newland\Contracts\Neos\Search\SuggestRequest;

class SearchBackendMock implements SearchBackend
{

    public $initializeCalled = false;
    public $afterIndexingCalled = false;

    public $sources = [];

    /** @var IndexRecordModification[] */
    public $modifications = [];

    public $identifiersToRetainWhenDeleting = [];

    public $searchRequests = [];

    public $searchResult;

    public function __construct()
    {
        $this->searchResult = new SearchResultCollection(0);
    }

    public function initialize(): void
    {
        $this->initializeCalled = true;
    }

    public function setSource(string $source): void
    {
        $this->sources[] = $source;
    }

    public function createOrUpdateIndexEntry(IndexRecordModification $modification): void
    {
        $this->modifications[] = $modification;
    }

    public function afterIndexing(): void
    {
        $this->afterIndexingCalled = true;
    }

    public function deleteObsoleteIndexEntries(array $identifiersToRetain): void
    {
        $this->identifiersToRetainWhenDeleting[] = $identifiersToRetain;
    }

    public function search(SearchRequest $request): SearchResultCollection
    {
        $this->searchRequests[] = $request;
        return $this->searchResult;
    }

    public function suggest(SuggestRequest $request): array
    {
        $this->searchRequests[] = $request;
        return $this->searchResult;
    }
}
