<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Tests\Unit\Utility;

use Newland\Toubiz\Search\Neos\Utility\ArrayUtility;
use PHPUnit\Framework\TestCase;

class ArrayUtilityTest extends TestCase
{
    public function testFindsAdditionOfAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([], [ 'foo' => 'bar' ]);
        self::assertArrayHasKey('foo', $result);
        self::assertEquals('bar', $result['foo']);
    }

    public function testFindsDeletionOfAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'foo' => 'bar' ], []);
        self::assertArrayHasKey('foo', $result);
        self::assertEquals('bar', $result['foo']);
    }

    public function testFindsChangeOfAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'foo' => 'bar' ], [ 'foo' => 'baz' ]);
        self::assertArrayHasKey('foo', $result);
        self::assertEquals('baz', $result['foo']);
    }


    public function testFindsAdditionOfDeepAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([], [ 'deep' => [ 'foo' => 'bar' ] ]);
        self::assertArrayHasKey('deep', $result);
        self::assertArrayHasKey('foo', $result['deep']);
        self::assertEquals('bar', $result['deep']['foo']);
    }

    public function testFindsDeletionOfDeepAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'deep' => [ 'foo' => 'bar' ] ], [ 'deep' => [] ]);
        self::assertArrayHasKey('deep', $result);
        self::assertArrayHasKey('foo', $result['deep']);
        self::assertEquals('bar', $result['deep']['foo']);
    }

    public function testFindsChangeOfDeepAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'deep' => [ 'foo' => 'bar' ] ], [ 'deep' => [ 'foo' => 'baz' ] ]);
        self::assertArrayHasKey('deep', $result);
        self::assertArrayHasKey('foo', $result['deep']);
        self::assertEquals('baz', $result['deep']['foo']);
    }

    public function testReturnsEmptyArrayIfNoDifference(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'deep' => [ 'foo' => 'bar' ] ], [ 'deep' => [ 'foo' => 'bar' ] ]);
        self::assertEmpty($result);
    }

    public function testIgnoresEmptyArrays(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([], [ 'deep' => [] ]);
        self::assertEmpty($result);
    }

    public function testEmptyExplode(): void
    {
        self::assertSame([ 'foo', 'bar' ], ArrayUtility::emptyExplode(',', 'foo ,, bar,'));
    }
}
