<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Tests\Unit\Utility;

use Newland\Toubiz\Search\Neos\Utility\ArrayUtility;
use PHPUnit\Framework\TestCase;

class ArrayUtilityTest extends TestCase
{
    public function testFindsAdditionOfAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ ], [ 'foo' => 'bar' ]);
        $this->assertArrayHasKey('foo', $result);
        $this->assertEquals('bar', $result['foo']);
    }

    public function testFindsDeletionOfAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'foo' => 'bar' ],  [ ]);
        $this->assertArrayHasKey('foo', $result);
        $this->assertEquals('bar', $result['foo']);
    }

    public function testFindsChangeOfAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'foo' => 'bar' ],  [ 'foo' => 'baz' ]);
        $this->assertArrayHasKey('foo', $result);
        $this->assertEquals('baz', $result['foo']);
    }


    public function testFindsAdditionOfDeepAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ ], [ 'deep' => ['foo' => 'bar' ] ]);
        $this->assertArrayHasKey('deep', $result);
        $this->assertArrayHasKey('foo', $result['deep']);
        $this->assertEquals('bar', $result['deep']['foo']);
    }

    public function testFindsDeletionOfDeepAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'deep' => ['foo' => 'bar' ] ], [ 'deep' => [] ]);
        $this->assertArrayHasKey('deep', $result);
        $this->assertArrayHasKey('foo', $result['deep']);
        $this->assertEquals('bar', $result['deep']['foo']);
    }

    public function testFindsChangeOfDeepAttribute(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'deep' => ['foo' => 'bar' ] ], [ 'deep' => [ 'foo' => 'baz' ] ]);
        $this->assertArrayHasKey('deep', $result);
        $this->assertArrayHasKey('foo', $result['deep']);
        $this->assertEquals('baz', $result['deep']['foo']);
    }
    public function testReturnsEmptyArrayIfNoDifference(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ 'deep' => ['foo' => 'bar' ] ], [ 'deep' => [ 'foo' => 'bar' ] ]);
        $this->assertEmpty($result);
    }

    public function testIgnoresEmptyArrays(): void
    {
        $result = ArrayUtility::arrayRecursiveDiff([ ], [ 'deep' => [ ] ]);
        $this->assertEmpty($result);
    }
}
