<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Tests;

use J6s\PhpArch\Component\Architecture;
use J6s\PhpArch\PhpArch;
use Neos\Flow\Tests\UnitTestCase;

class ArchitectureTest extends UnitTestCase
{
    public function testElasticSearchBackendMustNotBeReferencedDirectly(): void
    {
        $otherNamespaces = [
            'Command',
            'DataSource',
            'Eel',
            'Indexer',
            'Progress',
        ];

        $architecture = new Architecture();
        $architecture
            ->component('Elastic')
            ->identifiedByNamespace('Newland\\Toubiz\\Search\\Neos\\Backend\\ElasticSearch');
        $architecture
            ->component('Flowpack.Elastic')
            ->identifiedByNamespace('Flowpack\ElasticSearch');
        $architecture
            ->component('ONGR.ElasticSearchDSL')
            ->identifiedByNamespace('ONGR\\ElasticsearchDSL');

        foreach ($otherNamespaces as $component) {
            $architecture
                ->component($component)
                ->identifiedByNamespace('Newland\\Toubiz\\Search\\Neos\\' . $component)
                ->mustNotDependOn('Elastic')
                ->andMustNotDependOn('Flowpack.Elastic')
                ->andMustNotDependOn('ONGR.ElasticSearchDSL');
        }

        (new PhpArch())
            ->fromDirectory(__DIR__ . '/../Classes')
            ->validate($architecture)
            ->assertHasNoErrors();
    }
}
