<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Eel\Helper;

use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Configuration\ConfigurationManager;
use Newland\Contracts\Neos\Search\SearchBackend;
use Newland\Contracts\Neos\Search\SearchRequest;
use Newland\Contracts\Neos\Search\SearchResultCollection;
use Newland\Toubiz\Search\Neos\Backend\SearchBackendFactory;

/**
 * Eel Helper to process the ElasticSearch Query Result
 */
class SearchResultHelper implements ProtectedContextAwareInterface
{
    /**
     * @var array
     * @Flow\InjectConfiguration(path="availableScopes")
     */
    protected $availableScopes;

    /** @var SearchBackend */
    protected $searchBackend;
    public function injectSearchBackend(SearchBackendFactory $factory): void
    {
        $this->searchBackend = $factory->getSearchBackendFromConfiguration();
    }

    /**
     * Run search query using ElasticSearchConnector.
     *
     * Returns hits object of Elastic Search API Response Content.
     */
    public function query(
        string $searchTerm,
        int $itemsPerPage,
        int $currentPage,
        string $language,
        string $site,
        array $userEnabledScopes
    ): SearchResultCollection {
        $scopes = $userEnabledScopes ?: $this->scopesFromConfiguration();
        $scopes = $this->transformScopes($scopes, $site);
        $request = new SearchRequest($searchTerm, $language, $scopes, $itemsPerPage, $currentPage);
        return $this->searchBackend->search($request);
    }

    private function scopesFromConfiguration(): array
    {
        return array_keys(array_filter($this->availableScopes));
    }

    private function transformScopes(array $scopes, string $site): array
    {
        return array_map(
            function (string $scope) use ($site) {
                return $scope === 'page' ? $site : $scope;
            },
            $scopes
        );
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return true;
    }
}
