<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Utility;

class ArrayUtility
{
    public static function arrayRecursiveDiff($aArray1, $aArray2): array
    {
        $aReturn = [];

        foreach ($aArray1 as $mKey => $mValue) {
            if (!is_array($aArray2)) {
                $aReturn[$mKey] = 'ERROR: Diverting structure';
            } elseif (array_key_exists($mKey, $aArray2)) {
                if (is_array($mValue)) {
                    $aRecursiveDiff = static::arrayRecursiveDiff($mValue, $aArray2[$mKey]);
                    if (count($aRecursiveDiff)) {
                        $aReturn[$mKey] = $aRecursiveDiff;
                    }
                } elseif (strpos((string) $mValue, '@placeholder') !== false) {
                    $aReturn[$mKey] = 'ERROR: Placeholder found';
                }
            } else {
                $aReturn[$mKey] = $mValue;
            }
        }
        return $aReturn;
    }
}
