# Toubiz search package for Neos CMS.

This package provides search functionality into Neos. It uses elasticsearch to index and retrieve results.

Instructions for technical and editorial integration:
https://newland.atlassian.net/wiki/spaces/TEC/pages/1078886680/Search


## Configuration of page indexing

#### DocumentNodeIndexer
The document node indexer indexes all properties from a document node and its content node children. By default, boolean and numerical values are excluded from the index.

The indexer follows a blacklist-approach. This way, editors don't have to be reminded to manually add all of their properties of content nodes to a search configuration. However, sometimes it makes sense to exclude certain properties from the index as they might not bring useful or even wrong information (from the viewpoint of a search index). To ignore certain properties, you simply add them to the list.
```
Newland:
  Toubiz:
    Search:
      Neos:
        indexers:
          'Newland\Toubiz\Search\Neos\Indexer\DocumentNodeIndexer':
            configuration:
              nodeTypes:
                'Neos.Neos:Document':
                  ignoredProperties:
                    - myCustomIgnoredProperty
                    - anotherProperty
```

Some properties may contain default values that are hidden or not overwritten by the editor. To strip default values from the search index, configure them accordingly.
```
Newland:
  Toubiz:
    Search:
      Neos:
        indexers:
          'Newland\Toubiz\Search\Neos\Indexer\DocumentNodeIndexer':
            configuration:
              nodeTypes:
                'Neos.Neos:Document':
                  ignoredStrings:
                    - Pre-Line
                    - Title goes here
```

For each indexed entry, a title and description is stored for use in search results. You can override both with custom flow queries to adapt them to your needs.
```
Newland:
  Toubiz:
    Search:
      Neos:
        indexers:
          'Newland\Toubiz\Search\Neos\Indexer\DocumentNodeIndexer':
            configuration:
              title: ${q(node).property('title')}
              description: ${q(node).children('main').find('[instanceof Neos.Neos:Content][content != ""]').property('content')}
```

## Implementing own indexers and result renderings.
To index custom records and their rendering, you need a few things.

### The indexer
Obviously, an indexer class is needed which fills the search index with your data. This is quite simple and you can have a look at the `IndexerInterface` as well as the `AbstractIndexer` class. Depending on what you want to implement, you may also have a look at the `AbstractNodeIndexer` or the `AbstractRecordIndexer`.

Your custom indexers can be configured inside your project's or package's `Settings.yaml`.
```
Newland:
  Toubiz:
    Search:
      Neos:
        indexers:
          'Vendor\PackageName\Indexers\MyCustomIndexer':
            enable: true
            configuration: []
```

When you now run `php flow indexer:run`, the command controller will pick up your class and execute the expected methods.

### Rendering
In order to add custom rendering for certain results, add cases to the `Newland.Toubiz.Search.Neos:SearchResultRenderer` prototype.

```
prototype(Newland.Toubiz.Search.Neos:SearchResultRenderer).foo {
      condition = ${searchHit._source.source == 'Vendor\Namespace\MyCustomIndexer'}
      renderer = Newland.Toubiz.Search.Neos:GenericSearchResult {
          url = 'https://foobar.com'
          title = ${'custom title: ' + searchHit._source.title}
      }
}
```

See also:
* [Newland.Toubiz.Search.Neos:SearchResultRenderer](./Resources/Private/Fusion/Search/SearchResultRenderer.fusion)
* [Newland.Toubiz.Search.Neos:GenericSearchResult](./Resources/Private/Fusion/Search/GenericSearchResult.fusion)
