<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Indexer;

use Newland\Toubiz\Search\Neos\Domain\Model\SearchIndex;

class IndexRecordModification
{

    /** @var string */
    protected $identifier;

    /** @var string */
    protected $title;

    /** @var string */
    protected $description;

    /** @var string */
    protected $content;

    /** @var string|null */
    protected $scope;

    /** @var string|null */
    protected $language;

    /** @var mixed|null */
    protected $source;

    public function __construct(
        string $identifier,
        string $title,
        string $description,
        string $content
    ) {
        $this->identifier = $identifier;
        $this->title = $title;
        $this->description = $description;
        $this->content = $content;
    }

    public function mapInto(SearchIndex $index): SearchIndex
    {
        $index->setIdentifier($this->identifier);
        $index->setContent($this->content);
        $index->setTitle($this->title);
        $index->setDescription($this->description);
        if ($this->scope !== null) {
            $index->setScope($this->scope);
        }
        if ($this->language !== null) {
            $index->setLanguage($this->language);
        }
        if ($this->source !== null) {
            $source = \is_string($this->source) ? $this->source : \get_class($this->source);
            $index->setSource($source);
        }

        return $index;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function setIdentifier(string $identifier): self
    {
        $this->identifier = $identifier;
        return $this;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;
        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;
        return $this;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function setContent(string $content): self
    {
        $this->content = $content;
        return $this;
    }

    public function getScope(): ?string
    {
        return $this->scope;
    }

    public function setScope(?string $scope): self
    {
        $this->scope = $scope;
        return $this;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function setLanguage(?string $language): self
    {
        $this->language = $language;
        return $this;
    }

    public function getSource()
    {
        return $this->source;
    }

    public function setSource($source): self
    {
        $this->source = $source;
        return $this;
    }
}
