<?php declare(strict_types=1);

namespace Newland\Toubiz\Search\Neos\Domain\PropertyMapper;

use Neos\Error\Messages\Error;
use Neos\Flow\Property\Exception;
use Neos\Flow\Property\PropertyMappingConfigurationInterface;
use Neos\Flow\Property\TypeConverter\AbstractTypeConverter;
use Neos\Flow\Property\TypeConverterInterface;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchQuery;

class SearchQueryPropertyMapper extends AbstractTypeConverter
{

    protected $sourceTypes = [ 'array' ];
    protected $targetType = SearchQuery::class;
    protected $priority = 101;

    /**
     * Actually convert from $source to $targetType, taking into account the fully
     * built $convertedChildProperties and $configuration.
     *
     * The return value can be one of three types:
     * - an arbitrary object, or a simple type (which has been created while mapping).
     *   This is the normal case.
     * - NULL, indicating that this object should *not* be mapped
     *   (i.e. a "File Upload" Converter could return NULL if no file has been uploaded,
     *   and a silent failure should occur.
     * - An instance of \Neos\Error\Messages\Error -- This will be a user-visible error message later on.
     * Furthermore, it should throw an Exception if an unexpected failure (like a security error)
     * occurred or a configuration issue happened.
     *
     * @param mixed $source
     * @param string $targetType
     * @param array $convertedChildProperties
     * @param PropertyMappingConfigurationInterface $configuration
     * @return mixed|Error the target type, or an error object if a user-error occurred
     * @throws Exception\TypeConverterException thrown in case a developer error occurred
     * @api
     */
    public function convertFrom(
        $source,
        $targetType,
        array $convertedChildProperties = [],
        PropertyMappingConfigurationInterface $configuration = null
    ) {
        $searchQuery = new SearchQuery();
        $searchQuery->setQueryString($source['queryString']);

        if (array_key_exists('scopes', $source)) {
            $searchQuery->setScopes($source['scopes']);
        } elseif (array_key_exists('scope', $source)) {
            $searchQuery->setScopes([ $source['scope'] ]);
        }

        if (array_key_exists('language', $source)) {
            $searchQuery->setLanguage($source['language']);
        }

        return $searchQuery;
    }
}
