<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * Search result model.
 *
 * Represents the search index entry together with the original object.
 *
 * @Flow\Scope("singleton")
 */
class SearchResult
{
    /**
     * @var SearchIndex
     */
    protected $searchIndex;

    /**
     * @var mixed
     */
    protected $originalObject;

    public function setSearchIndex(SearchIndex $searchIndex): void
    {
        $this->searchIndex = $searchIndex;
    }

    public function getSearchIndex(): SearchIndex
    {
        return $this->searchIndex;
    }

    public function setOriginalObject($originalObject): void
    {
        $this->originalObject = $originalObject;
    }

    public function getOriginalObject()
    {
        return $this->originalObject;
    }
}
