<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * Object finder factory.
 *
 * @Flow\Scope("singleton")
 */
class ObjectFinderFactory
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration(path="indexers")
     * @var array
     */
    protected $configuration;

    public function get(string $indexerName): AbstractObjectFinder
    {
        $configuration = $this->configuration[$indexerName]['configuration']['objectFinder'];
        $instance = $this->indexer($configuration['class']);
        $instance->setConfiguration($configuration['configuration']);
        return $instance;
    }

    private function indexer(string $class): AbstractObjectFinder
    {
        return new $class();
    }
}
