# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.10.3] - 2019-06-19
## Fixed
- Fixed the query arguments to validate correctly the existing indexes in the database.

## [1.10.2] - 2019-06-19
### Action Required
- To prevent duplicate entries in linkhandler fields please ensure that the project does not
  contain any additional configuration for POI & Event linkhandlers. Configuration such as the
  following can be safely removed:
```yaml
Newland:
  NeosCommon:
    linkhandler:
      recordTypes:
        tour:
          handler: 'Newland\Toubiz\Poi\Neos\LinkHandler\ArticleLinkHandler'
        gastronomy:
          handler: 'Newland\Toubiz\Poi\Neos\LinkHandler\ArticleLinkHandler'
```

## [1.10.0] - 2019-06-07
### Fixed
- Fixed DocumentNode indexer failing if document node does not exist for dimension values
- Fixed ajax calls for new search requests and pagination.

## [1.1.0] - 2019-05-17
### Added
- Multiple scopes can now be supplied to the search query

## Changed
- Search URIs now respect language routing as definde by RoutingBehaviourHooks.

## Fixed
- Scopes now have meaningful names
- Empty nodes are no longer added to the search index

## Potentially Breaking
- As a result of the URI changes you might have to pass a `referenceNode` to the `search:searchActionUri`
  viewhelper.
- This version of the search package needs `Newland.Toubiz.Poi.Neos` 1.8.2 and `Newland.Toubiz.Events.Neos`
  1.7.2 or later.

## 1.0.0
### Added
- Property for document and content nodes to exclude nodes from search results
- Property for document nodes to control the search result relevance
- Indexer for document nodes and their child content nodes
- Indexing registration possibility to add custom indexers
- Configuration options to include whole content nodes or properties of nodes
- "LIKE" search
- "Fulltext" search
- Storing of search queries
- View helpers to build correct uri paths for searches outside the plugin
- Page frame provider integration
- Search word highlighting
- Language scoping and search options
- Site node scoping
- Multi-language uri segments for page frame provider
