<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\ObjectFinder;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\ContentRepository\Domain\Service\Context;
use Neos\ContentRepository\Domain\Service\ContextFactoryInterface;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Utility\Now;
use Neos\Neos\Domain\Service\ContentContext;

/**
 * Document node object finder.
 *
 * @Flow\Scope("singleton")
 */
class DocumentNodeObjectFinder extends AbstractObjectFinder implements ObjectFinderInterface
{
    /**
     * @var ContextFactoryInterface
     * @Flow\Inject
     */
    protected $contextFactory;

    public function find()
    {
        $options = [];
        if ($this->getSearchIndex()->getLanguage()) {
            $options['dimensions'] = [
                'language' => [$this->getSearchIndex()->getLanguage()],
            ];
        }

        $context = $this->getContext($options);
        if ($context === null) {
            return null;
        }

        $selector = sprintf('#%s', $this->getSearchIndex()->getIdentifier());
        return (new FlowQuery([ $context->getCurrentSiteNode() ]))
            ->find($selector)
            ->get(0);
    }

    protected function getContext(array $options = []): ?ContentContext
    {
        $context = $this->contextFactory->create(
            array_merge(
                [
                    'workspaceName' => 'live',
                    'currentDateTime' => new Now(),
                    'dimensions' => [],
                    'invisibleContentShown' => false,
                    'removedContentShown' => false,
                    'inaccessibleContentShown' => false,
                ],
                $options
            )
        );

        return ($context instanceof ContentContext) ? $context : null;
    }
}
