<?php
namespace Newland\Toubiz\Search\Neos\ViewHelpers;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchResult;

/**
 * Partial path view helper.
 *
 * Resolves the configured partial path for rendering a search result.
 *
 * @Flow\Scope("singleton")
 */
class PartialPathViewHelper extends AbstractViewHelper
{
    /**
     * The configuration for this package.
     *
     * @Flow\InjectConfiguration(path="indexers")
     * @var array
     */
    protected $configuration;

    /**
     * @param SearchResult $searchResult
     * @return string|boolean
     */
    public function render(SearchResult $searchResult = null)
    {
        if (!$searchResult) {
            return false;
        }

        $indexerName = $searchResult->getSearchIndex()->getSource();
        $indexerConfiguration = $this->configuration[$indexerName]['configuration'];
        return $indexerConfiguration['searchResultTemplate'];
    }
}
