<?php
namespace Newland\Toubiz\Search\Neos\Domain\Search\Mysql;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\QueryBuilder;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\Doctrine\Repository;
use Newland\Toubiz\Search\Neos\Domain\Model\SearchQuery;
use Newland\Toubiz\Search\Neos\Domain\Search\AbstractSearch;
use Newland\Toubiz\Search\Neos\Domain\Search\SearchInterface;

/**
 * Search implementation for "LIKE" queries.
 *
 * This is the slowest form of queries as it cannot use any
 * database indices to speed uf querying.
 *
 * @Flow\Scope("singleton")
 */
class LikeSearch extends AbstractSearch implements SearchInterface
{
    /**
     * Search given query.
     *
     * @param SearchQuery $search
     * @param Repository $repository
     * @return QueryBuilder
     */
    public function getQuery(SearchQuery $search, $repository)
    {
        $query = $repository->createQueryBuilder('i')
                            ->where('i.content LIKE :full_search')
                            ->setParameter('full_search', '%' . $search->getQueryString() . '%');

        foreach ($search->getSearchWords() as $word) {
            $query->orWhere('i.content LIKE :full_word_search')
                  ->setParameter('full_word_search', '%' . $word . '%');
        }

        return $query;
    }
}
