<?php
namespace Newland\Toubiz\Poi\Neos\Migration\Transformations;

use Neos\ContentRepository\Domain\Model\NodeData;
use Neos\ContentRepository\Migration\Transformations\AbstractTransformation;

class PrefixCategories extends AbstractTransformation
{
    /**
     * @var string
     */
    protected $propertyName;

    /**
     * @var string
     */
    protected $topicType = '';

    /**
     * @param string $propertyName
     * @return void
     */
    public function setProperty($propertyName): void
    {
        $this->propertyName = $propertyName;
    }

    /**
     *
     * @param string $topicType
     * @return void
     */
    public function setTopicType($topicType): void
    {
        $this->topicType = $topicType;
    }

    public function isTransformable(NodeData $node): bool
    {
        return $node->hasProperty($this->propertyName);
    }

    /**
     * Change the property on the given node.
     *
     * @param NodeData $node
     * @return NodeData
     */
    public function execute(NodeData $node): NodeData
    {
        $currentPropertyValue = $node->getProperty($this->propertyName);
        foreach ($currentPropertyValue as $i => $item) {
            if (strpos($item, $this->propertyName . ':') === false) {
                $currentPropertyValue[$i] = $this->topicType . ':' . $item;
            } else {
                $currentPropertyValue[$i] = $item;
            }
        }
        $node->setProperty($this->propertyName, $currentPropertyValue);

        return $node;
    }
}
