<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\FilteredTeaserList;

use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Tests\Factory\AddressFactory;

class FilteredCityTeaserListTest extends FilteredTeaserListTestCase
{

    protected function articleType(): int
    {
        return ArticleConstants::TYPE_CITY;
    }

    public function testDoesNotFindCitiesWithSimilarZipCodes(): void
    {
        $addressFactory = new AddressFactory($this->objectManager);
        $city1 = $this->articleFactory->create([
               'name' => '__FIRST_CITY__',
               'mainType' => ArticleConstants::TYPE_CITY,
               'mainAddress' => $addressFactory->make([ 'zip' => '12345' ]),
              'language' => 'de',
           ]);
        $this->articleFactory->create([
              'name' => '__SECOND_CITY__',
              'mainType' => ArticleConstants::TYPE_CITY,
              'mainAddress' => $addressFactory->make([ 'zip' => '12345' ]),
              'language' => 'de',
          ]);

        $this->node->setProperty('preselectedCities', [ $city1->getPersistenceObjectIdentifier() ]);
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);

        $this->assertResponseNotContains('__SECOND_CITY__', $response);
        $this->assertResponseContains('__FIRST_CITY__', $response);
    }
}
