<?php
namespace Newland\Toubiz\Poi\Neos\ViewHelpers\Uri\OutdoorActive;

class KmlViewHelper extends AbstractOutdoorActiveUriViewHelper
{

    /**
     * Must return a URL template that may contain one of the following placeholders:
     * - `{article}`: The complete article Object
     * - `{outdoorActive.client}`: Outdoor active project
     * - `{outdoorActive.apiKey}`: Outdoor active api Key
     *
     * @return string
     */
    protected function url(): string
    {
        return '//www.outdooractive.com/kml_generate'
            . '?i={article.outdoorActiveId}'
            . '&project={outdoorActive.client}'
            . '&key={outdoorActive.apiKey}';
    }
}
