<?php declare(strict_types=1);

namespace Newland\Toubiz\Poi\Neos\Tests\Integration\Lists;

use Newland\Toubiz\Api\ObjectAdapter\Attributes\GastronomyAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class GastronomyListTest extends AbstractListTestCase
{
    protected function articleType(): int
    {
        return ArticleConstants::TYPE_GASTRONOMY;
    }

    public function testCanBeFilteredForAwards(): void
    {
        $this->gastronomyWithDecorations('__WITH_DEHOGA__', [ GastronomyAttributes::HOUSE_DECORATION_DEHOGA ]);
        $this->gastronomyWithDecorations('__WITH_MICHELIN__', [ GastronomyAttributes::HOUSE_DECORATION_MICHELIN ]);
        $this->gastronomyWithDecorations('__WITH_BOTH__', [ GastronomyAttributes::HOUSE_DECORATION_DEHOGA, GastronomyAttributes::HOUSE_DECORATION_MICHELIN ]);
        $this->gastronomyWithDecorations('__WITH_NONE__', [ ]);

        // Without any filters: All should be displayed
        $response = $this->browser->request($this->nodeUri());
        $this->assertResponseOk($response);
        $this->assertResponseContains('__WITH_DEHOGA__', $response);
        $this->assertResponseContains('__WITH_MICHELIN__', $response);
        $this->assertResponseContains('__WITH_BOTH__', $response);
        $this->assertResponseContains('__WITH_NONE__', $response);
    }

    private function gastronomyWithDecorations(string $name, array $decorations): Article
    {
        $value = [
            'label' => '2 Kochl\\u00f6ffel',
            'description' => "Der Schlemmer-Atlas erscheint seit 1973 j\u00e4hrlich Ende Oktober und\r\nverzeichnet in seiner 36. Auflage f\u00fcr das Jahr 2010 rund 4.000 Restaurants\r\nin Deutschland, Belgien, Elsass, Luxemburg, Niederlande, \u00d6sterreich,\r\nS\u00fcdtirol und der Schweiz. Die Bewertung der Restaurants erfolgt mit einem\r\nKochl\u00f6ffelsymbol, wobei ein Kochl\u00f6ffel f\u00fcr \u0084ambitionierte K\u00fcche\u0093 steht,\r\nw\u00e4hrend die H\u00f6chstwertung f\u00fcnf Kochl\u00f6ffel betr\u00e4gt. Kriterien sind\r\nRestaurant mit hervorragender K\u00fcche, erstklassige Grundprodukte, hohe\r\nKreativit\u00e4t und Qualit\u00e4t bei sehr guter und einfallsreicher Zubereitung\r\nder Speisen, ausgew\u00e4hlte gro\u00dfe Weine und ausgezeichneter Service in\r\nentsprechender Atmosph\u00e4re.\r\n www.schlemmer-atlas.de",
            'value' => 'twostar',
        ];
        $attributes = array_map(
            function(string $decoration) use ($value) {
                return $this->attributeFactory->make([ 'name' => $decoration, 'data' => $value ]);
            },
            $decorations
        );
        return $this->articleFactory->create([
             'mainType' => ArticleConstants::TYPE_GASTRONOMY,
             'name' => $name,
             'attributes' => $attributes,
        ]);
    }
}
